// Build this as an NT character mode executable...
// Modifications:
// 7/29/98	Alison Hine	Changed ping port to 6971
// 10/2/98	Alison Hine	Updated comments to reflect new fields

#include <stdio.h>
#include <winsock.h>

u_long my_inet_addr(
    char                    *dotFormat)
{
    u_long                  addr;
    int                     thisByte, digitsLastByte, byteCount;

    for(thisByte = 0, digitsLastByte = 0, byteCount = 0, addr = 0;
        1;
        dotFormat++) {

        if (*dotFormat == '.' || *dotFormat == '\0') {
            if (0 <= thisByte && thisByte <= 255) {
                addr        = (addr << 8) | thisByte;
                thisByte    = 0;
                byteCount++;
                if (!*dotFormat) {
                    if (byteCount == 4 && digitsLastByte > 0) {
                        return htonl(addr); // host to net byte order
                    }
                    else {
                        break;  // Invalid address - must have 4 bytes
                    }
                }
                digitsLastByte = 0;
            }
            else {
                break;  // Invalid - byte overflowed, or is too large.
            }
        }
        else {
            if (*dotFormat >= '0' && *dotFormat <= '9') {
                thisByte    *= 10;
                thisByte    += *dotFormat - '0';
                digitsLastByte++;
            }
            else {
                break;  // Invalid - not a decimal digit
            }
        }
    }
    return INADDR_ANY;
}



int main(
    int                 argc,
    char                *argv[])
{

    int                 i;
    WSADATA             startupData;
    WORD                reqVersion;
    int                 nAddresses;
    struct hostent      *host;
    u_long              addresses[256], IP;
    struct sockaddr_in  toAddr;
    struct sockaddr_in  fromAddr;
    int                 fromAddrLen;
    SOCKET              sock;
    char                buf[256];
    u_long              dontBlock;
    u_long              bytesAvail;
    int                 failed;


    if (argc < 2) {
        printf("Usage: <pinggpl> #.#.#.# [foo.bar.baz.com] ...\n");
        exit(1);
    }

    // Initialize Winsock, version 1.1.
    reqVersion  = MAKEWORD(1, 1);
    memset(&startupData, 0, sizeof(startupData));
    if (!WSAStartup(reqVersion, &startupData)) {

        // Translate given addresses.
        for(i = 1, nAddresses = 0; i < argc; i++) {
            if ((addresses[nAddresses] = my_inet_addr(argv[i])) != INADDR_ANY) {
                nAddresses++;
            }
            else if ((host = gethostbyname(argv[i])) != NULL &&
                     host->h_addr_list != NULL) {
                addresses[nAddresses] = **((u_long **) host->h_addr_list);
                nAddresses++;
            }
            else {
                printf("Couldn't translate <%s>\n", argv[i]);
            }
        }

        // Set up (part of) the address to which we'll send pings.
        // Pinging to IPX is left as an exercise for the interested
        // reader.  GPL broadcasts on port 6970, and looks for pings
        // on port 6971	- changed 7/29/98 by Alison Hine
        memset(&toAddr, 0, sizeof(toAddr));
        toAddr.sin_family       = AF_INET;
        toAddr.sin_port         = htons(6971);

        // Create the socket via which we'll send our pings, and
        // to which GPL servers will reply.
        sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);

        // Force the socket not to block.
        dontBlock   = 1;
        if (sock != INVALID_SOCKET &&
            ioctlsocket(sock, FIONBIO, &dontBlock) != SOCKET_ERROR) {

            // Hit ^C to exit the program.
            for(failed = 0; !failed; ) {

                // Send any short datagram to each address specified.
                printf("ping...\n");
                for(i = 0; i < nAddresses; i++) {
                    toAddr.sin_addr.s_addr  = addresses[i];
                    if (sendto(sock,
                               "anything_1_byte_or_larger",
                               sizeof("anything_1_byte_or_larger"),
                               0,
                               (struct sockaddr *) &toAddr,
                               sizeof(toAddr)) == SOCKET_ERROR) {
                        failed  = 1;
                        break;
                    }
                } // foreach specified address

                // GPL only looks for pings once every 4 seconds,
                // so don't ping (much) more often than that.
                Sleep(4000);

                // Look for any replies.
                while(ioctlsocket(sock, FIONREAD, &bytesAvail) != 
                            SOCKET_ERROR &&
                      bytesAvail > 0) {
                    buf[0]  = '\0';
                    fromAddrLen = sizeof(fromAddr);
                    if (recvfrom(sock,
                                 buf,
                                 sizeof(buf),
                                 0,
                                 (struct sockaddr *) &fromAddr,
                                 &fromAddrLen) == SOCKET_ERROR) {
                        failed  = 1;
                        break;
                    }
                    IP  = fromAddr.sin_addr.s_addr;
                    printf("%03d.%03d.%03d.%03d:<%s>\n",
                                (IP & 0xff),
                                (IP & 0xff00) >> 8,
                                (IP & 0xff0000) >> 16,
                                (IP & 0xff000000) >> 24,
                                buf);
                    // buf will contain a string with the following
                    // components, each separated by a single ^A
                    // (ASCII 1) character.
                    //  -   Game identifier
                    //  -   Port number the game is accepting connections on
                    //      (be sure to htonl() this before using!)
                    //  -   F.Last name of player hosting the server
                    //  -   Track directory name
                    //  -   Car set directory name
                    //  -   <p>/<M> Number of players currently connected,
                    //      / maximum number of players allowed (always 20).
                    //  -   <m>/<M> Minimum/maximum driver rating allowed
                    //      Will always be 1/3
                    //  -   Race type (0=novice, 1=intermediate short, etc.)
                    //  -   Other race options - ignore.
                    //  -   [y|n] y=Server is in session, n=server is
                    //      at the track select screen.
                    //  -   Current session number
                    //  -   Session remaining (always seconds in GPL):
                    //      S# - seconds
                    //      L# - laps
                    //
                    // For example (replace @ with ^A)
                    // GPL.0.1.1.0@32766@R.Cassidy@spa@cars67@1/20@1/3@4@4@n@0@S327
                }
            } // forever

            // No point in closing the socket...
        }
        else {
            printf("Either couldn't create socket, or tell it not to block.\n");
        }
        WSACleanup();   // not much point here, either, eh?
    }
    else {
        printf("Could not start Winsock.\n");
    }
    return 0;
}


